
# coding: utf-8

# # Expression Trees

# What's an *expression tree*?

# In[1]:

import pymbolic.primitives as p
x = p.Variable("x")
y = p.Variable("y")
x


# Let's look what happens with a simple expression:

# In[2]:

x+5


# It does not get evaluated.
# 
# ---
# 
# Let's look at its type and structure in more detail.

# In[3]:

u = x+5


# In[4]:

type(u)


# In[5]:

u.children


# OK, easy. What if we introduce a product?

# In[6]:

u = x + 4*y
u


# In[7]:

u.children[0]


# In[8]:

u.children[1]


# In[9]:

u.children[1].children[0]


# In[22]:

u.children[1].children[1]


# This structure is a called a *tree*, because there is a *root* and *branches*.
