
# coding: utf-8

# # Accessing Python Syntax Trees

# It is also possible to access code that is written in Python. This works using the `ast` module, and works as follows:

# In[1]:

SRC = """
def f(x, y):
    return 2*x + y**2 + 5
"""

import ast
tree = ast.parse(SRC)

print(ast.dump(tree))


# It is possible to transcribe the expressions here into the form discussed earlier.

# In[2]:

from pymbolic.interop.ast import ASTToPymbolic
expr = ASTToPymbolic()(tree.body[0].body[0].value)
print(expr)


# But beware when defining languages this way. Python has very well-defined semantics, and the user will expect that your way of executing their code is a good match for their mental model of what the code should do. As such, it may be better to start with a "blank slate" in terms of language design, so as to not run afoul of already formed expectations.
