
# coding: utf-8

# # Hello PyOpenCL

# In[1]:

import pyopencl as cl
import numpy as np
import numpy.linalg as la

mf = cl.mem_flags


# This notebook demonstrates the simplest PyOpenCL workflow that touches all essential pieces:
# 
# * Data transfer
# * Kernel compilation
# * Execution

# In[2]:

a = np.random.rand(50000).astype(np.float32)


# Now create a context `ctx` and a command queue `queue`:

# In[3]:

ctx = cl.create_some_context()

queue = cl.CommandQueue(ctx)


# Now allocate a buffer. `Buffer(context, flags, size=None, hostbuf=None)`

# In[4]:

a_buf = cl.Buffer(ctx, mf.READ_WRITE, size=a.nbytes)


# Then transfer data:

# In[5]:

cl.enqueue_copy(queue, a_buf, a)


# Here's our kernel source code:

# In[6]:

prg = cl.Program(ctx, """
    __kernel void twice(__global float *a)
    {
      int gid = get_global_id(0);
      a[gid] = 2*a[gid];
    }
    """).build()


# Run the kernel.

# In[7]:

prg.twice(queue, a.shape, None, a_buf)


# Copy the data back.

# In[8]:

result = np.empty_like(a)

cl.enqueue_copy(queue, result, a_buf)


# Check the result.

# In[9]:

print(la.norm(result - 2*a), la.norm(a))


# In[ ]:



