
# coding: utf-8

# # Indexing and Broadcasting in Numpy

# Embedding mini-languages in Python has a long tradition. In this section of the tutorial, we will explore some examples of this practice.

# The first example we will consider is so-called *broadcasting* in numpy. It may look shallow at first sight, but it and its associated operations constitute a considerable subset of the array programming language APL.

# In[3]:

import numpy as np


# In[4]:

a = np.arange(4)
b = np.arange(3) * 10
print(a)
print(b)


# In[7]:

a.reshape(-1, 1).shape


# In[10]:

x = a.reshape(-1, 1) + b
x


# In[12]:

np.sum(x, axis=0)

