
# coding: utf-8

# # UFL, the 'Unified Form Language'

# UFL is part of FEniCS, where it is used to describe finite element problems that are to be solved using the framework. The appearance of the following code snippet should look sufficiently familiar, and it should be readily apparent how language such as this could be taken in and processed using the tools that we have seen:

# In[ ]:

from dolfin import *



# Create mesh and define function space

mesh = UnitSquareMesh(8, 8)

V = FunctionSpace(mesh, "Lagrange", 1)



# Define boundary condition

u0 = Function(V)

bc = DirichletBC(V, u0, "x[0] < DOLFIN_EPS || x[0] > 1.0 - DOLFIN_EPS")



# Define variational problem

u = TrialFunction(V)

v = TestFunction(V)

f = Expression("10*exp(-(pow(x[0] - 0.5, 2) + pow(x[1] - 0.5, 2)) / 0.02)",

               degree=1)

g = Expression("sin(5*x[0])", degree=1)

a = inner(grad(u), grad(v))*dx()

L = f*v*dx() + g*v*ds()

