
# coding: utf-8

# # Loopy: Reductions
# 
# ## Setup code

# In[11]:

import numpy as np
import pyopencl as cl
import pyopencl.array
import pyopencl.clrandom
import loopy as lp


# In[12]:

ctx = cl.create_some_context()
queue = cl.CommandQueue(ctx)


# In[13]:

n = 1024
a = cl.clrandom.rand(queue, (n, n), dtype=np.float32)
x = cl.clrandom.rand(queue, (n,), dtype=np.float32)


# ## Capturing matrix-vector multiplication

# In[14]:

knl = lp.make_kernel(
    "{[i,k]: 0<=i,k<n}",
    "b[i] = sum(k, a[i, k]*x[k])"
    )


# In[15]:

knl = lp.set_options(knl, write_cl=True)
evt, _ = knl(queue, a=a, x=x)


# In[ ]:




# In[ ]:



