
# coding: utf-8

# # Exercise: DSLs and Code generation with Loopy (open-ended)
# 
# 1. Define a small domain-specific language for image processing. Operations you could support include:
#     * `blur(n, img)`: To keep things simple, take an average of the neighboring $n\times n$ pixels.
#     * `mask(x, y, width, height)`. (`loopy` supports `if(condition, then, else)`, which maps to an `If(cond, then, else)` node in pymbolic.)
#     * Blending and nonlinear filtering using arithmetic
# 2. Using your language, implement a filter that blurs the top left quarter of an image
# 3. Implement your language "conventionally", using functions and loopy kernels
# 4. Implement your language by capturing an expression tree and executing that.
# 5. Think of and try to implement (at least) one optimization you could apply to the expression tree. You may use [Halide](http://halide-lang.org/) as inspiration if you like.

# In[ ]:



